/*
 * File    : ETT_PCA9548.H
 * Author  : ETT CO.,LTD 
 *         : Modify From https://github.com/RobTillaart/Arduino/tree/master/libraries/PCF8574
 * Update  : October 2018        
 * Purpose : Library PCA9548A For I2C Interface Arduino
 * Support : ESP32
 *         : ESP8266
 *         : MEGA32U4
 */
 
//=================================================================================
#include "ETT_PCA9548.h"
#include <Wire.h>
//=================================================================================

//=================================================================================
//=================================================================================
ETT_PCA9548::ETT_PCA9548(const uint8_t deviceAddress)
{
  //===============================================================================
  _address    = deviceAddress;
  _dataIn     = 0xFF;
  _dataOut    = 0xFF;
  _error      = PCA9548_OK;
  //===============================================================================
}
//=================================================================================

//=================================================================================
// Initial PCA9548A
//=================================================================================
// Input : val = Begin Bus Statte Value
//=================================================================================
void ETT_PCA9548::begin(uint8_t val)
{
  //===============================================================================
  _dataOut = val;
  //===============================================================================
  Wire.beginTransmission(_address);
  Wire.write(_dataOut);
  _error = Wire.endTransmission();
  //===============================================================================
}
//=================================================================================

//=================================================================================
void ETT_PCA9548::enableBus()                                                    // Enable Bus(0)
{
  //===============================================================================
  _dataOut = 0x01;                                                               // Select Enable Bus0 
  //===============================================================================
  Wire.beginTransmission(_address);
  Wire.write(_dataOut);
  _error = Wire.endTransmission();
  //===============================================================================
}
//=================================================================================

//=================================================================================
void ETT_PCA9548::enableBus(uint8_t bus)                                         // Enable Bus(0..7)
{
  //===============================================================================
  if(bus > 7)
  {
    _error = PCA9548_BUS_ERROR;
  }
  //===============================================================================
   _dataOut |= (1 << bus);                                                       // Enable Bus(0..7) 
  //===============================================================================
  Wire.beginTransmission(_address);
  Wire.write(_dataOut);
  _error = Wire.endTransmission();
  //===============================================================================
}
//=================================================================================

//=================================================================================
void ETT_PCA9548::disableBus()                                                   // Disable All Bus
{
  //===============================================================================
  _dataOut = 0x00;                                                               // Disable All Bus 
  //===============================================================================
  Wire.beginTransmission(_address);
  Wire.write(_dataOut);
  _error = Wire.endTransmission();
  //===============================================================================
}
//=================================================================================

//=================================================================================
void ETT_PCA9548::disableBus(uint8_t bus)                                        // Disable Bus(0..7)
{
  //===============================================================================
  if(bus > 7)
  {
    _error = PCA9548_BUS_ERROR;
  }
  //===============================================================================
   _dataOut &= ~(1 << bus);                                                      // Disable Bus(0..7) 
  //===============================================================================
  Wire.beginTransmission(_address);
  Wire.write(_dataOut);
  _error = Wire.endTransmission();
  //===============================================================================
}
//=================================================================================

//=================================================================================
// Read PCA9548A Bus
//=================================================================================
uint8_t ETT_PCA9548::readBus()
{
  //===============================================================================
  if(Wire.requestFrom(_address, (uint8_t)1) != 1)
  {
    _error = PCA9548_I2C_ERROR;
    return _dataIn;                                                              // last value
  }
  //===============================================================================
  _dataIn = Wire.read();
  //===============================================================================
  return _dataIn;
  //===============================================================================
}
//=================================================================================

//=================================================================================
// Get Last Error State
//=================================================================================
int ETT_PCA9548::lastError()
{
  //===============================================================================
  int e = _error;
  //===============================================================================
  _error = PCA9548_OK;
  //===============================================================================
  return e;
  //===============================================================================
}
//=================================================================================

//=================================================================================
// END OF FILE
//=================================================================================

